/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.powercell.blocks;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.powercell.PowerCellConfig;
import mcjty.rftoolspower.modules.powercell.PowerCellModule;
import mcjty.rftoolspower.modules.powercell.blocks.PowerCellTileEntity;
import mcjty.rftoolspower.modules.powercell.data.Tier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PowerCellBlock
extends BaseBlock
implements INBTPreservingIngredient {
    public static final BooleanProperty UPPER = BooleanProperty.m_61465_((String)"upper");
    public static final BooleanProperty LOWER = BooleanProperty.m_61465_((String)"lower");

    public RotationType getRotationType() {
        return RotationType.NONE;
    }

    public PowerCellBlock(Tier tier) {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> {
            long power = 0L;
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound != null) {
                power = tagCompound.m_128454_("Energy");
            }
            long totpower = 0L;
            if (stack.m_41720_() == PowerCellModule.CELL1_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER1_MAXRF.get());
            } else if (stack.m_41720_() == PowerCellModule.CELL2_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER2_MAXRF.get());
            } else if (stack.m_41720_() == PowerCellModule.CELL3_ITEM.get()) {
                totpower = PowerCellTileEntity.safeCast(PowerCellConfig.TIER3_MAXRF.get());
            }
            return power + " (max " + totpower + " RF/FE)";
        })}).tileEntitySupplier((pos, state) -> new PowerCellTileEntity(tier, pos, state)));
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity te;
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            long energy = stack.m_41782_() ? stack.m_41783_().m_128454_("energy") : 0L;
            powercell.setLocalEnergy(energy);
            powercell.getNetwork();
            powercell.markDirtyQuick();
        }
    }

    protected boolean wrenchUse(Level world, BlockPos pos, Direction side, Player player) {
        BlockEntity te;
        if (!world.f_46443_ && (te = world.m_7702_(pos)) instanceof PowerCellTileEntity) {
            PowerCellTileEntity powercell = (PowerCellTileEntity)te;
            powercell.toggleMode(side);
        }
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = super.m_5573_(context);
        Level world = context.m_43725_();
        return (BlockState)((BlockState)state.m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(world.m_8055_((pos = context.m_8083_()).m_7494_()).m_60734_() == this))).m_61124_((Property)LOWER, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7495_()).m_60734_() == this));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.m_61124_((Property)UPPER, (Comparable)Boolean.valueOf(facingState.m_60734_() == this));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)LOWER, (Comparable)Boolean.valueOf(facingState.m_60734_() == this));
        }
        return stateIn;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UPPER, LOWER});
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public Collection<String> getTagsToPreserve() {
        return Collections.singleton("BlockEntityTag");
    }
}

